<?php
################################################################################
# @Name : /plugins/kanban/kanban.php
# @Desc : display ticket in kanban form
# @call : /menu.php
# @parameters : 
# @Author : Boris MA
# @Create : 20/04/2017
# @Update : 04/12/2025
# @Version : 1.2
################################################################################

//default filter values
if(!$_POST['technician']) $_POST['technician']='%';
if(!$_POST['type']) $_POST['type']='%';
if(!$_POST['user']) $_POST['user']='%';

echo '
<div class="page-header">
	<h1 class="page-title text-primary-m2">
		<i class="fa fa-calendar-check text-primary-m2"><!----></i> 
		'.T_('Kanban').'
	</h1>
</div>
<div class="mb-2" >
	<form name="filter" method="POST">
		'.T_('Filtres').' : 
		<select style="width:auto;" class="form-control form-control-sm d-inline-block" name="technician" id="technician" onchange="submit()">
			';
			$qry=$db->prepare("SELECT `id`,`firstname`,`lastname` FROM `tusers` WHERE (`profile`=0 OR `profile`=4) AND `disable`=0 ORDER BY `lastname`");
			$qry->execute();
			while($row=$qry->fetch()) {
				if ($row['id'] == $_POST['technician']) 
				{ 
					echo '<option value="'.$row['id'].'" selected>'.$row['firstname'].' '.$row['lastname'].'</option>'; 
				} else {
					echo '<option value="'.$row['id'].'" >'.$row['firstname'].' '.$row['lastname'].'</option>'; 
				}
			}
			$qry->closeCursor();
			if($_POST['technician']=='%') {echo '<option value="%" selected >'.T_('Tous les techniciens').'</option>'; } else {echo '<option value="%">'.T_('Tous les techniciens').'</option>'; }
			echo '
		</select> 

		<select style="width:auto;" class="form-control form-control-sm d-inline-block" name="type" id="type" onchange="submit()">
			';
			$qry=$db->prepare("SELECT `id`,`name` FROM `ttypes` ORDER BY `name`");
			$qry->execute();
			while($row=$qry->fetch()) {
				if ($row['id'] == $_POST['type']) 
				{ 
					echo '<option value="'.$row['id'].'" selected>'.$row['name'].'</option>'; 
				} else {
					echo '<option value="'.$row['id'].'" >'.$row['name'].'</option>'; 
				}
			}
			$qry->closeCursor();
			if($_POST['type']=='%') {echo '<option value="%" selected >'.T_('Tous les types').'</option>'; } else {echo '<option value="%">'.T_('Tous les types').'</option>'; }
			echo '
		</select> 

		<select style="width:auto;" class="form-control form-control-sm d-inline-block" name="user" id="user" onchange="submit()">
			';
			$qry=$db->prepare("SELECT `id`,`firstname`,`lastname` FROM `tusers` WHERE `profile`!=0 AND `profile`!=4 AND `disable`=0 ORDER BY `lastname`");
			$qry->execute();
			while($row=$qry->fetch()) {
				if ($row['id'] == $_POST['user']) 
				{ 
					echo '<option value="'.$row['id'].'" selected>'.$row['firstname'].' '.$row['lastname'].'</option>'; 
				} else {
					echo '<option value="'.$row['id'].'" >'.$row['firstname'].' '.$row['lastname'].'</option>'; 
				}
			}
			$qry->closeCursor();
			if($_POST['user']=='%') {echo '<option value="%" selected >'.T_('Tous les demandeurs').'</option>'; } else {echo '<option value="%">'.T_('Tous les demandeurs').'</option>'; }
			echo '
		</select> 
		
	</form>
</div>
<div class="card bcard h-auto overflow-hidden shadow border-0">
	<div class="card-body p-0 table-responsive-xl">
		';

		//count number of unassigned ticket
		$qry=$db->prepare("SELECT COUNT(`id`) FROM `tincidents` WHERE `disable`='0' AND (`technician`='0' AND `t_group`='0')");
		$qry->execute();
		$cnt_unassigned=$qry->fetch();
		$qry->closeCursor();

		echo '
		<table id="sample-table-1" class="table table-bordered table-bordered table-striped table-hover text-dark-m2">
			<thead>
				<tr>
					<th style="width:100%" class="text-center text-danger">
						<i class="fa fa-user "></i> '.T_('Non affectés').' ('.$cnt_unassigned[0].')
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td>
						';
						$qry=$db->prepare("SELECT `id`,`title`,`criticality`,`date_create` FROM `tincidents` WHERE `disable`='0' AND (`technician`='0' AND `t_group`='0')");
						$qry->execute();
						while($ticket=$qry->fetch()) 
						{
							//define color and title
							$color='primary';
							$title=T_('Normal');
							if((strtotime($ticket['date_create'])) < (strtotime(date("Y-m-d H:i:s"))) - (3600 * 24 * 13)) {$color='warning'; $title=T_('Ancien > 14j');}
							if($ticket['criticality']==1) {$color='danger'; $title=T_('Critique');}

							echo '
							<div class="col-lg-3">
								<a title="'.$title.'" target="about_blank" style="text-decoration:none" href="index.php?page=ticket&id='.$ticket['id'].'">
									<div role="button" class="d-style border-1 bgc-'.$color.'-l4 brc-'.$color.'-m3 p-2 mt-2 shadow-sm overflow-hidden radius-1">
										<h4 class="text-'.$color.'-d3">
											#'.$ticket['id'].'
										</h4>
										<p class="text-dark-d1">
											'.ucfirst($ticket['title']).'
										</p>
									</div>
								</a>
							</div>
							';
						}
						$qry->closeCursor();
						echo '
					</td>
				</tr>
			</tbody>
		</table>
	</div>
</div>

<div class="mt-4 card bcard h-auto overflow-hidden shadow border-0">
	<div class="card-body p-0 table-responsive-xl">
			<table id="sample-table-1" class="table table-striped table-bordered">
				<thead>
					<tr>
						';
						//overall counters
						$qry=$db->prepare("SELECT COUNT(`id`) FROM `tincidents` WHERE `disable`='0' AND `state`='1' AND `technician`!=0");
						$qry->execute();
						$cnt_wait=$qry->fetch();
						$qry->closeCursor();

						$qry=$db->prepare("SELECT COUNT(`id`) FROM `tincidents` WHERE `disable`='0' AND `state`='2'  AND `technician`!=0");
						$qry->execute();
						$cnt_current=$qry->fetch();
						$qry->closeCursor();

						$qry=$db->prepare("SELECT COUNT(`id`) FROM `tincidents` WHERE `disable`='0' AND `state`='6'  AND `technician`!=0");
						$qry->execute();
						$cnt_return=$qry->fetch();
						$qry->closeCursor();

						$qry=$db->prepare("SELECT COUNT(`id`) FROM `tincidents` WHERE `disable`='0' AND `state`='3' AND DATE(date_res) > (NOW() - INTERVAL 7 DAY)  AND `technician`!=0");
						$qry->execute();
						$cnt_resolve=$qry->fetch();
						$qry->closeCursor();

						echo '
						<th class="text-center">
							<i class="fa fa-user"></i> '.T_('Technicien').'
						</th>
						<th class="text-center text-primary">
							<i class="fa fa-hourglass-start"></i> '.T_('Attente PEC').' ('.$cnt_wait[0].')
						</th>
						<th class="text-center text-warning">
							<i class="fa fa-bars-progress"></i> '.T_('En cours').' ('.$cnt_current[0].')
						</th>
						<th class="text-center text-pink">
							<i class="fa fa-reply"></i> '.T_('Attente Retour').' ('.$cnt_return[0].')
						</th>
						<th class="text-center text-success">
							<i class="fa fa-check"></i> '.T_('Résolus (< 7 j)').' ('.$cnt_resolve[0].')
						</th>
					</tr>
				</thead>
				<tbody>
				';
				$qry=$db->prepare("SELECT `id`,`firstname`,`lastname` FROM `tusers` WHERE `disable`='0' AND (`profile`=0 OR `profile`=4) AND `id` LIKE :technician ORDER BY `lastname`");
				$qry->execute(array('technician' => $_POST['technician']));
				while($technician=$qry->fetch()) 
				{
					echo '
					<tr>
						<td>
							<h5>'.ucfirst($technician['firstname']).' '.strtoupper($technician['lastname']).'</h5>
						</td>
						<td>
							';
							//display tickets block
							$qry2=$db->prepare("SELECT `id`,`title`,`criticality`,`date_create` FROM `tincidents` WHERE `disable`=0 AND `technician`=:technician AND `state`=1 AND `type` LIKE :type AND `user` LIKE :user");
							$qry2->execute(array('technician' => $technician['id'], 'type' => $_POST['type'], 'user' => $_POST['user']));
							while($ticket=$qry2->fetch()) 
							{
								//define color and title
								$color='primary';
								$title=T_('Normal');
								if((strtotime($ticket['date_create'])) < (strtotime(date("Y-m-d H:i:s"))) - (3600 * 24 * 13)) {$color='warning'; $title=T_('Ancien > 14j');}
								if($ticket['criticality']==1) {$color='danger'; $title=T_('Critique');}
								echo '
								<a title="'.$title.'" target="about_blank" style="text-decoration:none" href="index.php?page=ticket&id='.$ticket['id'].'">
									<div role="button" class="d-style border-1 bgc-'.$color.'-l4 brc-'.$color.'-m3 p-2 mt-2 shadow-sm overflow-hidden radius-1">
										<h4 class="text-'.$color.'-d3">
											#'.$ticket['id'].'
										</h4>
										<p class="text-dark-d1">
											'.ucfirst($ticket['title']).'
										</p>
									</div>
								</a>
								';
							}
							$qry2->closeCursor();
							echo '
						</td>
						<td>
							';
							//display tickets block
							$qry2=$db->prepare("SELECT `id`,`title`,`criticality`,`date_create` FROM `tincidents` WHERE `disable`=0 AND `technician`=:technician AND `state`=2  AND `type` LIKE :type AND `user` LIKE :user");
							$qry2->execute(array('technician' => $technician['id'], 'type' => $_POST['type'], 'user' => $_POST['user']));
							while($ticket=$qry2->fetch()) 
							{
								//define color and title
								$color='primary';
								$title=T_('Normal');
								if((strtotime($ticket['date_create'])) < (strtotime(date("Y-m-d H:i:s"))) - (3600 * 24 * 13)) {$color='warning'; $title=T_('Ancien > 14j');}
								if($ticket['criticality']==1) {$color='danger'; $title=T_('Critique');}
								echo '
								<a title="'.$title.'" target="about_blank" style="text-decoration:none" href="index.php?page=ticket&id='.$ticket['id'].'">
									<div role="button" class="d-style border-1 bgc-'.$color.'-l4 brc-'.$color.'-m3 p-2 mt-2 shadow-sm overflow-hidden radius-1">
										<h4 class="text-'.$color.'-d3">
											#'.$ticket['id'].'
										</h4>
										<p class="text-dark-d1">
											'.ucfirst($ticket['title']).'
										</p>
									</div>
								</a>
								';
							}
							$qry2->closeCursor();
							echo '
						</td>
						<td>
							';
							//display tickets block
							$qry2=$db->prepare("SELECT `id`,`title`,`criticality`,`date_create` FROM `tincidents` WHERE `disable`=0 AND `technician`=:technician AND `state`=6 AND `type` LIKE :type AND `user` LIKE :user");
							$qry2->execute(array('technician' => $technician['id'], 'type' => $_POST['type'], 'user' => $_POST['user']));
							while($ticket=$qry2->fetch()) 
							{
								//define color and title
								$color='primary';
								$title=T_('Normal');
								if((strtotime($ticket['date_create'])) < (strtotime(date("Y-m-d H:i:s"))) - (3600 * 24 * 13)) {$color='warning'; $title=T_('Ancien > 14j');}
								if($ticket['criticality']==1) {$color='danger'; $title=T_('Critique');}
								echo '
								<a title="'.$title.'" target="about_blank" style="text-decoration:none" href="index.php?page=ticket&id='.$ticket['id'].'">
									<div role="button" class="d-style border-1 bgc-'.$color.'-l4 brc-'.$color.'-m3 p-2 mt-2 shadow-sm overflow-hidden radius-1">
										<h4 class="text-'.$color.'-d3">
											#'.$ticket['id'].'
										</h4>
										<p class="text-dark-d1">
											'.ucfirst($ticket['title']).'
										</p>
									</div>
								</a>
								';
							}
							$qry2->closeCursor();
							echo '
						</td>
						<td>
							';
							//display tickets block
							$qry2=$db->prepare("SELECT `id`,`title`,`criticality`,`date_create` FROM `tincidents` WHERE `disable`=0 AND `technician`=:technician AND `state`=3 AND DATE(date_res) > (NOW() - INTERVAL 7 DAY)  AND `type` LIKE :type AND `user` LIKE :user");
							$qry2->execute(array('technician' => $technician['id'], 'type' => $_POST['type'], 'user' => $_POST['user']));
							while($ticket=$qry2->fetch()) 
							{
								//define color and title
								$color='primary';
								$title=T_('Normal');
								if((strtotime($ticket['date_create'])) < (strtotime(date("Y-m-d H:i:s"))) - (3600 * 24 * 13)) {$color='warning'; $title=T_('Ancien > 14j');}
								if($ticket['criticality']==1) {$color='danger'; $title=T_('Critique');}
								echo '
								<a title="'.$title.'" target="about_blank" style="text-decoration:none" href="index.php?page=ticket&id='.$ticket['id'].'">
									<div role="button" class="d-style border-1 bgc-'.$color.'-l4 brc-'.$color.'-m3 p-2 mt-2 shadow-sm overflow-hidden radius-1">
										<h4 class="text-'.$color.'-d3">
											#'.$ticket['id'].'
										</h4>
										<p class="text-dark-d1">
											'.ucfirst($ticket['title']).'
										</p>
									</div>
								</a>
								';
							}
							$qry2->closeCursor();
							echo '
						</td>
					</tr>
					';
				}
				$qry->closeCursor();
				echo '
				</tbody>
			</table>
	</div>
</div>
';